//+-------------------------------------------------------------------
#property copyright "mladen"
#property link      "www.forex-tsd.com"
//+-------------------------------------------------------------------
#property indicator_separate_window
#property indicator_buffers 4
#property indicator_color1  ForestGreen
#property indicator_color2  OrangeRed
#property indicator_color3  OrangeRed
#property indicator_color4  DarkGray
#property indicator_width1  2
#property indicator_width2  2
#property indicator_width3  2
#property indicator_style4  STYLE_DOT

//
//
//
//
//

extern int Price         = PRICE_CLOSE;
extern int PriceShift    = 0;
extern int EmaPeriod     = 32;
extern int HighLowPeriod = 100;
extern int LwmaPeriod    = 6;
extern int LsmaPeriod    = 25;

double beh[];
double behda[];
double behdb[];
double sig[];
double trend[];

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int init()
{
   IndicatorBuffers(5);
   SetIndexBuffer(0,beh);
   SetIndexBuffer(1,behda);
   SetIndexBuffer(2,behdb);
   SetIndexBuffer(3,sig);
   SetIndexBuffer(4,trend);
   IndicatorShortName("Behgozin Strength Finder ("+EmaPeriod+","+HighLowPeriod+","+LwmaPeriod+","+LsmaPeriod+","+PriceShift+")");
   return(0);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

double work[];
int start()
{
   int i,r,counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
            int limit=Bars-counted_bars;
            if (ArrayRange(work,0)!=Bars) ArrayResize(work,Bars);

   //
   //
   //
   //
   //
           
   if (trend[limit]==-1) CleanPoint(limit,behda,behdb);
   for(i=limit, r=Bars-i-1; i>=0; i--,r++)
   {
      if ((i+PriceShift)>=0)
      {
         double price = iMA(NULL,0,1,0,MODE_SMA,Price,i+PriceShift);
         double ema   = iEma(price,EmaPeriod,r);
            if (ema != 0)
                  work[r] = 100.0*(price-ema)/ema;
            else  work[r] = 0;    
         double max = work[r];
         double min = work[r];
         for (int k=1; k<HighLowPeriod && (r-k)>=0; k++)
         {
            max = MathMax(max,work[r-k]);
            min = MathMin(min,work[r-k]);
         }
         behda[i] = EMPTY_VALUE;
         behdb[i] = EMPTY_VALUE;
         beh[i]   = iLwma(work[r]*(max-min),LwmaPeriod,r);
         sig[i]   = iLinr(beh[i],LsmaPeriod,r);
         trend[i] = trend[i+1];
            if (beh[i]>sig[i]) trend[i] =  1;
            if (beh[i]<sig[i]) trend[i] = -1;
            if (trend[i]==-1) PlotPoint(i,behda,behdb,beh);
      }
   }
   return(0);         
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

double workEma[][1];
double iEma(double price, double period, int r, int instanceNo=0)
{
   if (ArrayRange(workEma,0)!= Bars) ArrayResize(workEma,Bars);

   //
   //
   //
   //
   //
      
   double alpha = 2.0 / (1.0+period);
          workEma[r][instanceNo] = workEma[r-1][instanceNo]+alpha*(price-workEma[r-1][instanceNo]);
   return(workEma[r][instanceNo]);
}

//
//
//
//
//

double workLwma[][1];
double iLwma(double price, double period, int r, int instanceNo=0)
{
   if (ArrayRange(workLwma,0)!= Bars) ArrayResize(workLwma,Bars);
   
   //
   //
   //
   //
   //
   
   workLwma[r][instanceNo] = price;
      double sumw = period;
      double sum  = period*price;

      for(int k=1; k<period && (r-k)>=0; k++)
      {
         double weight = period-k;
                sumw  += weight;
                sum   += weight*workLwma[r-k][instanceNo];  
      }             
      return(sum/sumw);
}

//
//
//
//
//

double workLinr[][1];
double iLinr(double price, double period, int r, int instanceNo=0)
{
   if (ArrayRange(workLinr,0)!= Bars) ArrayResize(workLinr,Bars);

   //
   //
   //
   //
   //
   
      period = MathMax(period,1);
      workLinr[r][instanceNo] = price;
         double lwmw = period; double lwma = lwmw*price;
         double sma  = price;
         for(int k=1; k<period && (r-k)>=0; k++)
         {
            double weight = period-k;
                   lwmw  += weight;
                   lwma  += weight*workLinr[r-k][instanceNo];  
                   sma   +=        workLinr[r-k][instanceNo];
         }             
   
   return(3.0*lwma/lwmw-2.0*sma/period);
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

void CleanPoint(int i,double& first[],double& second[])
{
   if ((second[i]  != EMPTY_VALUE) && (second[i+1] != EMPTY_VALUE))
        second[i+1] = EMPTY_VALUE;
   else
      if ((first[i] != EMPTY_VALUE) && (first[i+1] != EMPTY_VALUE) && (first[i+2] == EMPTY_VALUE))
          first[i+1] = EMPTY_VALUE;
}

//
//
//
//
//

void PlotPoint(int i,double& first[],double& second[],double& from[])
{
   if (first[i+1] == EMPTY_VALUE)
      {
         if (first[i+2] == EMPTY_VALUE) {
                first[i]   = from[i];
                first[i+1] = from[i+1];
                second[i]  = EMPTY_VALUE;
            }
         else {
                second[i]   =  from[i];
                second[i+1] =  from[i+1];
                first[i]    = EMPTY_VALUE;
            }
      }
   else
      {
         first[i]  = from[i];
         second[i] = EMPTY_VALUE;
      }
}